///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Helper export method.
 *	This method is called once for each exported helper.
 *	\param		helper		[in] a structure filled with current helper information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ASCIIFormat::ExportHelper(const HelperDescriptor& helper)
{
	// 1) Export common information
	mHelpers.StoreASCII("\n///////////////////////////////////////////////////////////////////////////////////////////////////////////////////\n").StoreASCII("Helper:       ");
	ExportBasicInfo(&helper, &mHelpers);

	// 2) Export helper parameters
	// 2-1) Export helper's type
	mHelpers.StoreASCII("Helper type: ");
			if(helper.mHelperType==HTYPE_DUMMY)				mHelpers.StoreASCII("dummy object\n");
	else	if(helper.mHelperType==HTYPE_GIZMO_BOX)			mHelpers.StoreASCII("box gizmo\n");
	else	if(helper.mHelperType==HTYPE_GIZMO_SPHERE)		mHelpers.StoreASCII("sphere gizmo\n");
	else	if(helper.mHelperType==HTYPE_GIZMO_CYLINDER)	mHelpers.StoreASCII("cylinder gizmo\n");
	// 2-2) Export group data
	mHelpers.StoreASCII("Group head:  ").StoreASCII(helper.mIsGroupHead).StoreASCII("\n");
	// 2-3) Export gizmo data
	switch(helper.mHelperType)
	{
		case HTYPE_GIZMO_BOX:
		{
			mHelpers
				.StoreASCII("Length:  ").StoreASCII(helper.mLength).StoreASCII("\n")
				.StoreASCII("Width:   ").StoreASCII(helper.mWidth).StoreASCII("\n")
				.StoreASCII("Height:  ").StoreASCII(helper.mHeight).StoreASCII("\n");
		}
		break;

		case HTYPE_GIZMO_SPHERE:
		{
			mHelpers
				.StoreASCII("Radius:  ").StoreASCII(helper.mRadius).StoreASCII("\n")
				.StoreASCII("Hemi:    ").StoreASCII(helper.mHemi).StoreASCII("\n");
		}
		break;

		case HTYPE_GIZMO_CYLINDER:
		{
			mHelpers
				.StoreASCII("Radius:  ").StoreASCII(helper.mRadius).StoreASCII("\n")
				.StoreASCII("Height:   ").StoreASCII(helper.mHeight).StoreASCII("\n");
		}
		break;
	}
	return true;
}
